ScriptName RF:CooldownScript Extends ActiveMagicEffect

RF:TravelHandlerQuest Property TravelManager Mandatory Const Auto
RF:TutorialQuest Property TutorialManager Mandatory Const Auto

Message Property _RF_Message_CDStart Auto Mandatory Const
Message Property _RF_Message_CDFinish Auto Mandatory Const

WwiseEvent Property TheSoundOnFail Mandatory Const Auto
WwiseEvent Property TheSoundOnOK Mandatory Const Auto

GlobalVariable Property _RF_CooldownDuration Mandatory Const Auto

Event OnEffectStart(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, float afMagnitude, float afDuration)
    TheSoundOnFail.Play(akCaster)
    int Min = Math.Floor(afDuration / 60)
    If !TutorialManager.ShowTutorial(5)
        _RF_Message_CDStart.Show(Min)
    EndIF
    TravelManager.DisableFar(true)
EndEvent

Event OnEffectFinish(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, float afMagnitude, float afDuration)
    _RF_Message_CDFinish.Show()
    TravelManager.DisableFar(false)
    TheSoundOnOK.Play(akCaster)
EndEvent